/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.mainmenu;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.api.constants.JobType;
import noppes.npcs.api.constants.RoleType;
import noppes.npcs.client.Client;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.SubGuiNpcSelectTrader;
import noppes.npcs.client.gui.advanced.GuiNPCAdvancedLinkedNpc;
import noppes.npcs.client.gui.advanced.GuiNPCDialogNpcOptions;
import noppes.npcs.client.gui.advanced.GuiNPCFactionSetup;
import noppes.npcs.client.gui.advanced.GuiNPCLinesMenu;
import noppes.npcs.client.gui.advanced.GuiNPCMarks;
import noppes.npcs.client.gui.advanced.GuiNPCNightSetup;
import noppes.npcs.client.gui.advanced.GuiNPCScenes;
import noppes.npcs.client.gui.advanced.GuiNPCSoundsMenu;
import noppes.npcs.client.gui.animation.GuiNpcAnimation;
import noppes.npcs.client.gui.animation.GuiNpcEmotion;
import noppes.npcs.client.gui.roles.GuiJobFarmer;
import noppes.npcs.client.gui.roles.GuiNpcBard;
import noppes.npcs.client.gui.roles.GuiNpcCompanion;
import noppes.npcs.client.gui.roles.GuiNpcConversation;
import noppes.npcs.client.gui.roles.GuiNpcFollowerJob;
import noppes.npcs.client.gui.roles.GuiNpcGuard;
import noppes.npcs.client.gui.roles.GuiNpcHealer;
import noppes.npcs.client.gui.roles.GuiNpcItemGiver;
import noppes.npcs.client.gui.roles.GuiNpcSpawner;
import noppes.npcs.client.gui.roles.GuiNpcTransporter;
import noppes.npcs.client.gui.roles.GuiRoleDialog;
import noppes.npcs.client.gui.util.GuiButtonBiDirectional;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataAI;
import noppes.npcs.roles.RoleTrader;

public class GuiNpcAdvanced
extends GuiNPCInterface2
implements IGuiData,
ISubGuiListener {
    private boolean hasChanges;
    private final DataAI ais;

    public GuiNpcAdvanced(EntityNPCInterface npc) {
        super(npc, 4);
        this.ais = npc.ais;
        this.hasChanges = false;
        Client.sendData(EnumPacketServer.MainmenuAIGet, new Object[0]);
        Client.sendData(EnumPacketServer.MainmenuAdvancedGet, new Object[0]);
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        if (button.getID() != 5 && button.getID() != 8) {
            this.save();
        }
        switch (button.getID()) {
            case 3: {
                Client.sendData(EnumPacketServer.RoleGet, new Object[0]);
                break;
            }
            case 4: {
                Client.sendData(EnumPacketServer.JobGet, new Object[0]);
                break;
            }
            case 5: {
                this.hasChanges = true;
                int id = button.getValue();
                if (id > 8) {
                    ++id;
                }
                this.npc.advanced.setJob(id);
                this.func_73866_w_();
                break;
            }
            case 7: {
                NoppesUtil.openGUI((EntityPlayer)this.player, new GuiNPCLinesMenu(this.npc));
                break;
            }
            case 8: {
                this.hasChanges = true;
                this.npc.advanced.setRole(button.getValue());
                this.func_73866_w_();
                break;
            }
            case 9: {
                NoppesUtil.openGUI((EntityPlayer)this.player, new GuiNPCFactionSetup(this.npc));
                break;
            }
            case 10: {
                NoppesUtil.openGUI((EntityPlayer)this.player, new GuiNPCDialogNpcOptions(this.npc));
                break;
            }
            case 11: {
                NoppesUtil.openGUI((EntityPlayer)this.player, new GuiNPCSoundsMenu(this.npc));
                break;
            }
            case 12: {
                NoppesUtil.openGUI((EntityPlayer)this.player, new GuiNPCNightSetup(this.npc));
                break;
            }
            case 13: {
                NoppesUtil.openGUI((EntityPlayer)this.player, new GuiNPCAdvancedLinkedNpc(this.npc));
                break;
            }
            case 14: {
                NoppesUtil.openGUI((EntityPlayer)this.player, new GuiNPCScenes(this.npc));
                break;
            }
            case 15: {
                NoppesUtil.openGUI((EntityPlayer)this.player, new GuiNPCMarks(this.npc, this));
                break;
            }
            case 16: {
                NoppesUtil.openGUI((EntityPlayer)this.player, new GuiNpcAnimation((EntityCustomNpc)this.npc));
                break;
            }
            case 18: {
                NoppesUtil.openGUI((EntityPlayer)this.player, new GuiNpcEmotion((EntityCustomNpc)this.npc));
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.guiLeft + 15;
        int x1 = this.guiLeft + 85;
        int y = this.guiTop + 8;
        this.addLabel(new GuiNpcLabel(0, "role.name", x, y + 5));
        GuiNpcButton button = new GuiNpcButton(3, x + 230, y, 52, 20, "selectServer.edit");
        button.setEnabled(!this.ais.aiDisabled && this.npc.advanced.roleInterface.getEnumType().hasSettings);
        if (this.ais.aiDisabled) {
            button.setHoverText("hover.ai.disabled", new Object[0]);
        }
        this.addButton(button);
        button = new GuiButtonBiDirectional(8, x + 70, y, 155, 20, RoleType.getNames(), this.npc.advanced.roleInterface.getType());
        button.setEnabled(!this.ais.aiDisabled);
        TextComponentTranslation mess = new TextComponentTranslation("advanced.menu.hover.role." + this.npc.advanced.roleInterface.getType(), new Object[0]);
        if (this.ais.aiDisabled) {
            mess.func_150257_a((ITextComponent)new TextComponentTranslation("hover.ai.disabled", new Object[0]));
        }
        button.setHoverText(mess.func_150254_d(), new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(1, "job.name", x, (y += 22) + 5));
        button = new GuiNpcButton(4, x + 230, y, 52, 20, "selectServer.edit");
        button.setEnabled(!this.ais.aiDisabled && this.npc.advanced.jobInterface.getEnumType().hasSettings);
        if (this.ais.aiDisabled) {
            button.setHoverText("hover.ai.disabled", new Object[0]);
        }
        this.addButton(button);
        int id = this.npc.advanced.jobInterface.getType();
        if (id > 9) {
            --id;
        }
        button = new GuiButtonBiDirectional(5, x + 70, y, 155, 20, JobType.getNames(), id);
        button.setEnabled(!this.ais.aiDisabled);
        mess = new TextComponentTranslation("advanced.menu.hover.job." + id, new Object[0]);
        if (this.ais.aiDisabled) {
            mess.func_150257_a((ITextComponent)new TextComponentTranslation("hover.ai.disabled", new Object[0]));
        }
        button.setHoverText(mess.func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(7, x, y += 22, 195, 20, "advanced.lines");
        button.setHoverText("advanced.menu.hover.says", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(9, x1 += 126, y, 195, 20, "menu.factions");
        button.setHoverText("advanced.menu.hover.faction", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(10, x, y += 22, 195, 20, "dialog.dialogs");
        button.setHoverText("advanced.menu.hover.dialogs", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(11, x1, y, 195, 20, "advanced.sounds");
        button.setHoverText("advanced.menu.hover.sounds", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(12, x, y += 22, 195, 20, "advanced.night");
        button.setHoverText("advanced.menu.hover.night", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(13, x1, y, 195, 20, "global.linked");
        button.setHoverText("advanced.menu.hover.lines", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(14, x, y += 22, 195, 20, "advanced.scenes");
        button.setEnabled(!this.ais.aiDisabled);
        mess = new TextComponentTranslation("advanced.menu.hover.scenes", new Object[0]);
        if (this.ais.aiDisabled) {
            mess.func_150257_a((ITextComponent)new TextComponentTranslation("hover.ai.disabled", new Object[0]));
        }
        button.setHoverText(mess.func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(15, x1, y, 195, 20, "advanced.marks");
        button.setHoverText("advanced.menu.hover.marks", new Object[0]);
        this.addButton(button);
        Class model = null;
        if (this.npc instanceof EntityCustomNpc) {
            model = ((EntityCustomNpc)this.npc).modelData.entityClass;
        }
        boolean bo = model == null;
        button = new GuiNpcButton(16, x, y += 22, 195, 20, "movement.animation");
        button.setEnabled(bo);
        button.setHoverText("advanced.menu.hover.anim", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(18, x, y + 22, 195, 20, "advanced.emotion");
        button.setEnabled(bo);
        button.setHoverText("animation.hover.eye", new TextComponentTranslation("gui.help.general", new Object[0]).func_150254_d(), new TextComponentTranslation("selectServer.edit", new Object[0]).func_150254_d());
        this.addButton(button);
    }

    @Override
    public void save() {
        if (this.hasChanges) {
            Client.sendData(EnumPacketServer.MainmenuAdvancedSave, this.npc.advanced.save(new NBTTagCompound()));
            this.hasChanges = false;
        }
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        if (compound.func_74764_b("RoleData")) {
            if (this.npc.advanced.roleInterface != null) {
                this.npc.advanced.roleInterface.load(compound);
            }
            if (this.npc.advanced.roleInterface != null) {
                switch (this.npc.advanced.roleInterface.getEnumType()) {
                    case TRADER: {
                        RoleTrader role = (RoleTrader)this.npc.advanced.roleInterface;
                        this.setSubGui(new SubGuiNpcSelectTrader(role.getMarketID()));
                        break;
                    }
                    case FOLLOWER: {
                        NoppesUtil.requestOpenGUI(EnumGuiType.SetupFollower);
                        break;
                    }
                    case BANK: {
                        NoppesUtil.requestOpenGUI(EnumGuiType.SetupBank);
                        break;
                    }
                    case TRANSPORTER: {
                        this.displayGuiScreen(new GuiNpcTransporter(this.npc));
                        break;
                    }
                    case COMPANION: {
                        this.displayGuiScreen(new GuiNpcCompanion(this.npc));
                        break;
                    }
                    case DIALOG: {
                        NoppesUtil.openGUI((EntityPlayer)this.player, new GuiRoleDialog(this.npc));
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (compound.func_74764_b("JobData")) {
            if (this.npc.advanced.jobInterface != null) {
                this.npc.advanced.jobInterface.load(compound);
            }
            if (this.npc.advanced.jobInterface != null) {
                switch (this.npc.advanced.jobInterface.getEnumType()) {
                    case BARD: {
                        NoppesUtil.openGUI((EntityPlayer)this.player, new GuiNpcBard(this.npc));
                        break;
                    }
                    case HEALER: {
                        NoppesUtil.openGUI((EntityPlayer)this.player, new GuiNpcHealer(this.npc));
                        break;
                    }
                    case GUARD: {
                        NoppesUtil.openGUI((EntityPlayer)this.player, new GuiNpcGuard(this.npc));
                        break;
                    }
                    case ITEM_GIVER: {
                        GuiNpcItemGiver.parent = this;
                        NoppesUtil.requestOpenGUI(EnumGuiType.SetupItemGiver);
                        break;
                    }
                    case FOLLOWER: {
                        NoppesUtil.openGUI((EntityPlayer)this.player, new GuiNpcFollowerJob(this.npc));
                        break;
                    }
                    case SPAWNER: {
                        NoppesUtil.openGUI((EntityPlayer)this.player, new GuiNpcSpawner(this.npc));
                        break;
                    }
                    case CONVERSATION: {
                        NoppesUtil.openGUI((EntityPlayer)this.player, new GuiNpcConversation(this.npc));
                        break;
                    }
                    case FARMER: {
                        NoppesUtil.openGUI((EntityPlayer)this.player, new GuiJobFarmer(this.npc));
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (compound.func_150297_b("NpcInteractLines", 10)) {
            this.npc.advanced.load(compound);
            this.func_73866_w_();
        } else if (compound.func_150297_b("NpcInv", 9)) {
            this.npc.inventory.readEntityFromNBT(compound);
            this.func_73866_w_();
        } else if (compound.func_150297_b("MovementType", 3)) {
            this.ais.readToNBT(compound);
        }
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        if (subgui instanceof SubGuiNpcSelectTrader) {
            this.hasChanges = true;
            RoleTrader role = (RoleTrader)this.npc.advanced.roleInterface;
            role.setMarket(((SubGuiNpcSelectTrader)subgui).id);
            this.save();
        }
    }
}

